#include <algorithm>
#include <iostream>
#include <sstream>
#include <vector>
#include <string>
#include <set>
#include <map>
#include <iterator>
#include <cmath>
#include <cstdlib>
#include <cstdio>
#include <cstring>
#include <cctype>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define ROF(i, a, b) for (int i = (b) - 1; i >= (a); --i)

typedef pair <int, int> pii;
typedef long long LL;
typedef LL ll;

const int INF = 1000000000;
const LL LINF = (LL) INF * (LL) INF;
const int MAXN = 1024;

struct Edge {
  int to, c, back;
  Edge() {}
  Edge(int to, int c, int back) : to(to), c(c), back(back) {}
};

int matrix[MAXN][MAXN];

int t;
vector <vector <Edge> > graph;
vector <bool> visited;


int min_way;

int dfs(int v, int curr) {
  if (v == t) {
    return curr;
  }

  visited[v] = true;
  
  for (auto it = graph[v].begin(); it != graph[v].end(); ++it) {
    auto &i = *it;
    if (!visited[i.to] && i.c >= min_way) {
      int get = dfs(i.to, min(curr, i.c));

      if (get) {
        i.c -= get;
        graph[i.to][i.back].c += get;
        
        return get;
      }
    }
  }
  return false;
}


int back_dfs(int v) {
  if (v == t) {
    return true;
  }

  visited[v] = true;
  
  for (auto it = graph[v].begin(); it != graph[v].end(); ++it) {
    auto &i = *it;
    if (!visited[i.to] && i.c) {
      if (back_dfs(i.to)) {
        return true;
      }
    }
  }
  
  return false;
}

int main() {

  while (true) {
    int n, m, s;
    cin >> n >> m >> s >> t;
    if (!n && !m && !s && !t) {
      return 0;
    }
    --s; --t;
    graph.clear();
    graph.resize(n);
    visited.resize(n);

    vector <pair <int, int> > edges(m);

    for (int i = 0; i != n; ++i)
      for (int j = 0; j != n; ++j)
        matrix[i][j] = -1;
    
    for (int i = 0; i != m; ++i) {
      int a, b;
      cin >> a >> b;
      --a; --b;

      if (matrix[a][b] != -1) {
        ++graph[a][matrix[a][b]].c;
        edges[i] = make_pair(a, matrix[a][b]);
      } else {
        graph[a].push_back(Edge(b, 1, graph[b].size()));
        graph[b].push_back(Edge(a, 0, graph[a].size() - 1));

        matrix[a][b] = graph[a].size() - 1;
      //  matrix[b][a] = graph[b].size() - 1;

        edges[i] = make_pair(a, graph[a].size() - 1);
      }
    }

  int answer = 0;

  min_way = 1 << 8;
  while (min_way) {
    int curr;
    do {
      visited.assign(n, false);
      curr = dfs(s, INF);
      answer += curr;
    } while (curr);
    min_way >>= 1;
  }


  int count = 0;
  for (auto it = edges.begin(); it != edges.end(); ++it) {
      //auto &j = graph[it->first][it->second];
      if (graph[it->first][it->second].c == 0) continue;

      --graph[it->first][it->second].c;
    //  ++graph[j.to][j.back].c;

      graph[graph[it->first][it->second].to].push_back(Edge(it->first, 1, graph[it->first].size()));
     // j = graph[it->first][it->second];
      graph[it->first].push_back(Edge(graph[it->first][it->second].to, 0, graph[graph[it->first][it->second].to].size() - 1));
    //  j = graph[it->first][it->second];

      visited.assign(n, false);
      if (back_dfs(s)) ++count;                   

      ++graph[it->first][it->second].c;
      graph[graph[it->first][it->second].to].pop_back();
      graph[it->first].pop_back();

     // --graph[j.to][j.back].c;
    }
//  }
  
    if (count) ++answer;
    cout << answer << ' ' << count << '\n';
  }
  return 0;
}